<?php

include 'db.php';

$sortbys = $_POST['sortbys'];
$buttonvals = $_POST['buttonvals'];
$searchIcon = trim($_POST['invoice']);
$invoice = $searchIcon;

// Base Query
$query = "
    SELECT 
        ins.invoice_id, 
        ins.invoice_no, 
        ins.Created_date AS invoicedate, 
        ins.Grand_total AS grandtotal, 
        ins.Balance AS due, 
        ins.Action_status,
        c.displayname AS customername, 
        ins.Payment_status AS paymentstatus, 
        ins.Store_status AS store_status,
        c.phonenumber AS customercontact,
        GROUP_CONCAT(p.Product_name SEPARATOR '|') AS product_names,
        GROUP_CONCAT(p.Product_image SEPARATOR '|') AS product_images,
        (SELECT COUNT(*) FROM invoice_data WHERE invoice_data.invoice_id = ins.invoice_id AND invoice_data.Delete_status=0) AS total_products
    FROM invoice ins
    INNER JOIN customer c ON c.id = ins.user_id
    INNER JOIN invoice_data ind ON ind.invoice_id = ins.invoice_id AND ind.Delete_status = 0
    INNER JOIN product p ON p.Product_id = ind.Product_id
    WHERE ins.Delete_status = 0
";

// Search Filter
if ($invoice != '') {
    $query .= " AND (LOWER(ins.invoice_no) LIKE '%$invoice%' 
                    OR LOWER(c.displayname) LIKE '%$invoice%' 
                    OR LOWER(c.phoneno) LIKE '%$invoice%')";
}

// Payment Status Filter
if ($sortbys != '') {
    $query .= " AND ins.Payment_status = '$sortbys'";
}

// Button Filters
if ($buttonvals == '1') {
    // Custom filter logic
} elseif ($buttonvals == '2') {
    // All filter logic
} elseif ($buttonvals == '3') {
    $today = date('Y-m-d');
    $query .= " AND DATE(ins.Created_date) = '$today'";
} elseif ($buttonvals == '4') {
    $yesterday = date("Y-m-d", strtotime("yesterday"));
    $query .= " AND DATE(ins.Created_date) = '$yesterday'";
} elseif ($buttonvals == '5') {
    $query .= " AND DATE(ins.Created_date) >= DATE_ADD(CURDATE(), INTERVAL -7 DAY)";
} elseif ($buttonvals == '6') {
    $query .= " AND DATE(ins.Created_date) >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
}

// Group By Clause
$query .= " GROUP BY ins.invoice_id";

// Execute Query
$result = mysqli_query($conn, $query);
$data = array();

while ($row = mysqli_fetch_assoc($result)) {
    $id = $row['invoice_id'];
    $sqls = "SELECT SUM(Payment_amount) AS totalcustomerpayment FROM payment WHERE Invoice_id = '$id'";
    $results = mysqli_query($conn, $sqls);
    $customerpaymentrow = mysqli_fetch_assoc($results);

    // Calculate Due Amount
    $dues = $row['grandtotal'] - $customerpaymentrow['totalcustomerpayment'];
    $dues = ($dues != "") ? number_format($dues, 2) : '0.00';

    // Prepare User Details
    $user_details = array(
        'id' => $id,
        'invoiceno' => $row['invoice_no'],
        'invoicedate' => $row['invoicedate'],
        'grandtotal' => $row['grandtotal'],
        'due' => $row['due'],
        'customername' => $row['customername'],
        'paymentstatus' => $row['paymentstatus'],
        'store_status' => $row['store_status'],
        'actionstatus' => $row['Action_status'],
        'customercontact' => $row['customercontact'],
        'product_names' => explode('|', $row['product_names']), // Array of product names
        'product_images' => explode('|', $row['product_images']), // Array of product images
        'totalproductcount' => $row['total_products'],
    );

    $data[] = $user_details;
}

echo json_encode($data);
?>